/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.Collections;
import kickass.parsing.misc.ParameterMap;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.Directive;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.state.EvaluationState;
import kickass.state.segments.Segment;
import kickass.state.segments.SegmentMemoryBlock;
import kickass.state.segments.SegmentParser;

public class SegmentoutDirective
extends Directive {
    private static int sequenceNo = 0;
    private ParameterMap parameters;
    private SegmentMemoryBlock.Entry memEntry;
    private Segment intermSegment;

    public SegmentoutDirective(ParameterMap parameterMap, SourceRange sourceRange) {
        super(sourceRange);
        this.parameters = parameterMap;
    }

    @Override
    public AsmNode copy() {
        return new SegmentoutDirective(this.parameters, this.range);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        SegmentParser.addErrorIfNotExists(this.parameters, Collections.emptySet(), true, evaluationState);
        SegmentParser.addErrorForUnknownParameters(this.parameters, SegmentParser.combiParameters, true, evaluationState);
        this.parameters.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        Object object;
        if (evaluationState.getPassNo() == 1) {
            this.memEntry = evaluationState.segmentMgr.getCurrentSegment().getCurrentMemoryBlock().createNewEntry();
        }
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        if (this.parameters.evaluateAllParameters(evaluationState)) {
            evaluationState.segmentMgr.invalidateMemoryPosition();
            return this;
        }
        if (this.intermSegment == null) {
            object = "<<.segmentout:" + sequenceNo++ + ">>";
            this.intermSegment = SegmentParser.createCombiSegment((String)object, this.parameters, this.range, evaluationState);
            this.intermSegment.initPass();
            this.intermSegment.close(evaluationState);
            evaluationState.segmentMgr.addSegment(this.intermSegment);
        }
        if (!this.intermSegment.isReadyToFinalize(evaluationState)) {
            evaluationState.segmentMgr.invalidateMemoryPosition();
            return this;
        }
        this.intermSegment.finalize(evaluationState);
        object = this.intermSegment.flatten(false);
        evaluationState.segmentMgr.increaseMemoryPosition(((Object)object).length);
        this.memEntry.fillEntry((byte[])object, this.range);
        evaluationState.setMadeMetaProgress();
        return new SideEffectOnlyOutput(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }
}

